<?php
function update_event_compliance($edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $fpr, $approver, $hod, $location, $department, $companyid, $editorid, $editorrole){
	$allComplianc = getAllCompliances($edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid); // get all the compliances for the compliance ID with 0 cycle id
	foreach($allComplianc as $allc){
		$old_data = "FPR:".$allc['fpr_id'].",Approver:".$allc['appr_id'].",HoD:".$allc['hod_id'].",Location:".$allc['location'].",Department:".$allc['department'];
		$new_data = "FPR:".$fpr.",Approver:".$approver.",HoD:".$hod.",Location:".$location.",Department:".$department;
		$updatedCompliance = updateComplianceEvent($edcomp, $allc['sr'], $fpr, $approver, $hod, $location, $department);
		if($updatedCompliance == 1){
			insertEditlog('event', $old_data, $new_data, $editorid, $editorrole, $allc['company_id'], $allc['compliance_id'], $allc['act_id'], $allc['sr']);
		} else {
			$showres = "Compliance Editing Failed";
		}
	}	
	// get all Event Based compliance data where cycle id is not equal 0 and status is not executed
	$allCompliances = getAllCompliancesGenerated($edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
	foreach($allCompliances as $allc){
		$updatedCompliance = updateComplianceEventNotZero($edcomp, $allc['sr'], $fpr, $approver, $hod, $location, $department);
	}
	return 1;
}

function update_event_compliance_whole($actid, $sr, $edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $fpr, $approver, $hod, $location, $department, $companyid, $editorid, $editorrole){
	$old_data = "FPR:".$prevfpr.",Approver:".$prevappr.",HoD:".$prevhod.",Location:".$prevloc.",Department:".$prevdep;
	$new_data = "FPR:".$fpr.",Approver:".$approver.",HoD:".$hod.",Location:".$location.",Department:".$department;
	$updatedCompliance = updateComplianceEvent($edcomp, $sr, $fpr, $approver, $hod, $location, $department);
	if($updatedCompliance == 1){
		insertEditlog('event', $old_data, $new_data, $editorid, $editorrole, $companyid, $edcomp, $actid, $sr);
	} else {
		$showres = "Compliance Editing Failed";
	}	
	// get all Event Based compliance data where cycle id is not equal 0 and status is not executed
	$allCompliances = getAllCompliancesGenerated($edcomp, $prevfpr, $prevappr, $prevhod, $prevloc, $prevdep, $companyid);
	foreach($allCompliances as $allc){
		$updatedCompliance = updateComplianceEventNotZero($edcomp, $allc['sr'], $fpr, $approver, $hod, $location, $department);
	}
	return 1;
}



function eventcompliancesStill($prevfpr, $prevappr, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT `company_compliance`.* FROM `company_compliance` JOIN `compliance` ON `company_compliance`.`compliance_id`=`compliance`.`id` WHERE `compliance`.`periodicity` LIKE '%event%' AND `company_compliance`.`status`!=7 AND `company_compliance`.`fpr_id`='$prevfpr' AND `company_compliance`.`appr_id`='$prevappr' AND `company_compliance`.`company_id`='$companyid' AND `cycle_id`=0");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}


function eventsStill($prevfpr, $prevappr, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("SELECT * FROM `company_event` WHERE `fpr_user_id`='$prevfpr' AND `appr_user_id`='$prevappr' AND `company_id`='$companyid' AND `cycle_id`=0");
		$query->execute();
		$result = $query->fetchAll();
		return $result;
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deleteEventCycle($prevfpr, $prevappr, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE `company_id`=? AND `act_id`=? AND `status` !=? AND `status`!=? AND `fpr_id`=? AND `appr_id`=?");
		$query->bindValue( 1, $companyid );
		$query->bindValue( 2, 99999 );
		$query->bindValue( 3, 7 );
		$query->bindValue( 4, 4 );
		$query->bindValue( 5, $prevfpr );
		$query->bindValue( 6, $prevappr );
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deleteEventforCycle($cycle_id, $fpr, $approver, $company_id){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_event` WHERE `cycle_id`=? AND `fpr_user_id`=? AND `appr_user_id`=? AND `company_id`=? AND `cycle_id`!=0");
		$query->bindValue(1, $cycle_id);
		$query->bindValue(2, $fpr);
		$query->bindValue(3, $approver);
		$query->bindValue(4, $company_id);
		$result = $query->execute();
		if($result){ return 1; } else { return 0;}
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deletegeneevent($complianceid, $sr, $fpr, $approver, $hod, $location, $department, $companyid){
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("DELETE FROM `company_compliance` WHERE `company_id`=? AND `act_id`=? AND `status` !=? AND `status`!=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? AND `company_id`=?");
		$query->bindValue( 1, $companyid );
		$query->bindValue( 2, $complianceid );
		$query->bindValue( 3, 7 );
		$query->bindValue( 4, 4 );
		$query->bindValue( 5, $fpr );
		$query->bindValue( 6, $approver );
		$query->bindValue( 7, $hod );
		$query->bindValue( 8, $location );
		$query->bindValue( 9, $department );
		$query->bindValue( 10, $companyid );
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function updategeneevent($complianceid, $prevfpr, $preappr, $prehod, $preloc, $predep, $fpr, $approver, $hod, $loc, $dep){
	$companyid = $_SESSION['company_id'];
	$dbh = connect_db();
	try{
		$query = $dbh->prepare("UPDATE `company_compliance` SET `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=? WHERE `company_id`=? AND `act_id`=? AND `status` !=? AND `status`!=? AND `fpr_id`=? AND `appr_id`=? AND `hod_id`=? AND `location`=? AND `department`=?");
		$query->bindValue( 1, $companyid );
		$query->bindValue( 2, $complianceid );
		$query->bindValue( 3, 7 );
		$query->bindValue( 4, 4 );
		$query->bindValue( 5, $fpr );
		$query->bindValue( 6, $approver );
		$query->bindValue( 7, $hod );
		$query->bindValue( 8, $location );
		$query->bindValue( 9, $department );
		$result = $query->execute();
		if($result){ return 1; } else { return 0; }
	} catch(Exception $e){
		return $e->getMessage();
	}
}

function deleteeventCyclesifNocompliance($prevfpr, $prevappr){
    $company_id = $_SESSION['company_id'];
	$check = eventcompliancesStill($prevfpr, $prevappr, $company_id);
	$checkEvents = eventsStill($prevfpr, $prevappr, $company_id);
	if(count($check) >=1 && count($checkEvents)>=1){
		return 1;
		//keep cycles
	} else {
		$deleteCyclesEvent = deleteEventCycle($prevfpr, $prevappr, $company_id);
		$deleteCyclesEvent = 1;
		if($deleteCyclesEvent == 1){
			return 1;
		} else {
			return 0;
		}
	}
}
?>